/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.VVP;
import tech.vvp.vvp.config.server.ExplosionConfigVVP;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.init.ModEntities;
import tech.vvp.vvp.init.ModItems;
import tech.vvp.vvp.init.ModSounds;

public class Bmp3Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CAMOUFLAGE_TYPE = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> HAS_CACTUS_BODY = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_CACTUS_TURRET = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_MANGAL_BODY = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> MISSILE_FIRE_COOLDOWN = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.m_135353_(Bmp3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final float X_TURRET = 0.00725625f;
    public static final float Y_TURRET = 2.7512188f;
    public static final float Z_TURRET = 0.2802875f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int reloadCoolDown;
    private static final int MISSILE_CD_TICKS = 10;
    public OBB obb1;
    public OBB obb2;
    public OBB obb3;
    public OBB obb4;
    public OBB obb5;
    public OBB obb6;
    public OBB obbTurret;

    public Bmp3Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Bmp3Entity>)((EntityType)ModEntities.BMP_3.get()), world);
    }

    public Bmp3Entity(EntityType<Bmp3Entity> type, Level world) {
        super(type, world);
        this.m_274367_(1.5f);
        this.obb1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.0f, 0.375f, 3.25f), new Quaternionf(), OBB.Part.BODY);
        this.obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.0f, 0.4375f, 1.0625f), new Quaternionf(), OBB.Part.BODY);
        this.obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.5f, 0.46875f, 3.65625f), new Quaternionf(), OBB.Part.BODY);
        this.obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.21875f, 0.625f, 3.78125f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
        this.obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.21875f, 0.625f, 3.78125f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
        this.obb6 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.5f, 0.46875f, 0.5625f), new Quaternionf(), OBB.Part.ENGINE1);
        this.obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.34375f, 0.25f, 1.40625f), new Quaternionf(), OBB.Part.TURRET);
    }

    public static Bmp3Entity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        Bmp3Entity entity = new Bmp3Entity((EntityType<Bmp3Entity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage((float)((Integer)VehicleConfigVVP.BRADLEY_CANNON_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)VehicleConfigVVP.BRADLEY_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfigVVP.BRADLEY_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/cannon_30mm.png")).sound1p((SoundEvent)ModSounds.BUSHMASTER_1P.get()).sound3p((SoundEvent)ModSounds.BUSHMASTER_3P.get()).sound3pFar((SoundEvent)ModSounds.BUSHMASTER_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.BUSHMASTER_VERYFAR.get()), new ProjectileWeapon().damage(9.5f).headShot(2.0f).zoom(false).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_CANNON.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/gun_7_62mm.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FAR.get()), new WgMissileWeapon().damage((float)((Integer)ExplosionConfigVVP.TOW_MISSILE_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)ExplosionConfigVVP.TOW_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius((float)((Integer)ExplosionConfigVVP.TOW_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.TOW_1P.get()).sound3p((SoundEvent)ModSounds.TOW_3P.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CANNON_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
        this.f_19804_.m_135372_(CAMOUFLAGE_TYPE, (Object)0);
        this.f_19804_.m_135372_(HAS_CACTUS_BODY, (Object)false);
        this.f_19804_.m_135372_(HAS_CACTUS_TURRET, (Object)false);
        this.f_19804_.m_135372_(HAS_MANGAL_BODY, (Object)false);
        this.f_19804_.m_135372_(MISSILE_FIRE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(MISSILE_COUNT, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CamouflageType", ((Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE)).intValue());
        compound.m_128379_("HasCactusBody", ((Boolean)this.f_19804_.m_135370_(HAS_CACTUS_BODY)).booleanValue());
        compound.m_128379_("HasCactusTurret", ((Boolean)this.f_19804_.m_135370_(HAS_CACTUS_TURRET)).booleanValue());
        compound.m_128379_("HasMangalBody", ((Boolean)this.f_19804_.m_135370_(HAS_MANGAL_BODY)).booleanValue());
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
        compound.m_128405_("MissileFireCooldown", ((Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN)).intValue());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)compound.m_128451_("CamouflageType"));
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
        this.f_19804_.m_135381_(HAS_CACTUS_TURRET, (Object)compound.m_128471_("HasMangal"));
        this.f_19804_.m_135381_(HAS_CACTUS_BODY, (Object)compound.m_128471_("HasFoliageBody"));
        this.f_19804_.m_135381_(HAS_MANGAL_BODY, (Object)compound.m_128471_("HasFoliage"));
        this.f_19804_.m_135381_(MISSILE_FIRE_COOLDOWN, (Object)compound.m_128451_("MissileFireCooldown"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public void m_6075_() {
        super.m_6075_();
        this.updateOBB();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(100.0f);
        }
        if (this.getLeftTrack() > 100.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(100.0f);
        }
        if (this.getRightTrack() > 100.0f) {
            this.setRightTrack(0.0f);
        }
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        this.terrainCompact(4.0f, 5.0f);
        this.inertiaRotate(1.0f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.lowHealthWarning();
        for (int i = 1; i < 7; ++i) {
            int rpm;
            Mob mob;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Mob) || !this.canShoot((LivingEntity)(mob = (Mob)entity)) || mob.m_5448_() == null || this.f_19797_ % (rpm = 20 / (this.mainGunRpm((LivingEntity)mob) / 60)) != 0) continue;
            this.vehicleShoot((LivingEntity)mob, i);
        }
        this.m_6210_();
    }

    public float turretYSpeed() {
        return 7.5f;
    }

    public float turretXSpeed() {
        return 8.0f;
    }

    public float turretMinPitch() {
        return -7.5f;
    }

    public float turretMaxPitch() {
        return 35.0f;
    }

    public Vec3 getTurretShootPos(Entity entity, float ticks) {
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.getWeaponIndex(0) == 0 ? this.transformPosition(transform, -0.25f, -0.15f, 2.7f) : (this.getWeaponIndex(0) == 2 ? this.transformPosition(transform, -0.1f, -0.15f, 2.7f) : this.transformPosition(transform, 0.0f, -0.4f, 0.45f));
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public float projectileVelocity(Entity entity) {
        if (this.getWeaponIndex(0) == 0) {
            return 20.0f;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 25.0f;
        }
        return 2.0f;
    }

    public float projectileGravity(Entity entity) {
        if (this.getWeaponIndex(0) == 0) {
            return 0.03f;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 0.05f;
        }
        return 0.0f;
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.07 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.12;
    }

    private void handleAmmo() {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            if (!InventoryTool.hasCreativeAmmoBox((Entity)this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        int mgAmmoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                return Ammo.RIFLE.get(stack) > 0;
            }
            return false;
        }).mapToInt(arg_0 -> ((Ammo)Ammo.RIFLE).get(arg_0)).sum() + this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.RIFLE_AMMO.get());
        if ((this.hasItem((Item)com.atsuishio.superbwarfare.init.ModItems.WIRE_GUIDE_MISSILE.get()) || hasCreativeAmmo) && this.reloadCoolDown <= 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) < 1) {
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) + 1));
            this.reloadCoolDown = 180;
            if (!hasCreativeAmmo) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.WIRE_GUIDE_MISSILE.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_MISSILE_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.SMALL_SHELL.get()));
        } else if (this.getWeaponIndex(0) == 2) {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE)));
        }
        this.f_19804_.m_135381_(MG_AMMO, (Object)mgAmmoCount);
        this.f_19804_.m_135381_(MISSILE_COUNT, (Object)this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.WIRE_GUIDE_MISSILE.get()));
    }

    public void vehicleShoot(LivingEntity living, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            if (!InventoryTool.hasCreativeAmmoBox((Entity)this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        if (type == 0) {
            if (this.getWeaponIndex(0) == 0) {
                if (this.cannotFire) {
                    return;
                }
                SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create(living);
                smallCannonShell.m_6034_(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_);
                smallCannonShell.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, this.projectileVelocity((Entity)living), 0.25f);
                this.m_9236_().m_7967_((Entity)smallCannonShell);
                ParticleTool.sendParticle((ServerLevel)((ServerLevel)this.m_9236_()), (ParticleOptions)ParticleTypes.f_123755_, (double)this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, (double)this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, (double)this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_, (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.0, (boolean)false);
                this.playShootSound3p(living, 0, 4, 12, 24, this.getTurretShootPos((Entity)living, 1.0f));
                ShakeClientMessage.sendToNearbyPlayers((Entity)this, (double)5.0, (double)6.0, (double)5.0, (double)9.0);
                this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
                this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
                this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 7));
                this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
                if (hasCreativeAmmo) {
                    return;
                }
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            } else if (this.getWeaponIndex(0) == 1) {
                if (this.cannotFireCoax) {
                    return;
                }
                if ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || hasCreativeAmmo) {
                    ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create(living).setGunItemId(this.m_6095_().m_20675_());
                    projectileRight.bypassArmorRate(0.2f);
                    projectileRight.m_6034_(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_);
                    projectileRight.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, this.projectileVelocity((Entity)living), 0.25f);
                    this.m_9236_().m_7967_((Entity)projectileRight);
                    if (!hasCreativeAmmo) {
                        ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                            if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                                return Ammo.RIFLE.get(stack) > 0;
                            }
                            return false;
                        }).findFirst().orElse(ItemStack.f_41583_);
                        if (!ammoBox.m_41619_()) {
                            Ammo.RIFLE.add(ammoBox, -1);
                        } else {
                            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                        }
                    }
                }
                this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
                this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
                this.playShootSound3p(living, 0, 3, 6, 12, this.getTurretShootPos((Entity)living, 1.0f));
            } else if (this.getWeaponIndex(0) == 2 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0) {
                if ((Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN) > 0) {
                    return;
                }
                WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create(living);
                wgMissileEntity.m_6034_(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_);
                wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, this.projectileVelocity((Entity)living), 0.0f);
                living.m_9236_().m_7967_((Entity)wgMissileEntity);
                this.playShootSound3p(living, 0, 6, 0, 0, this.getTurretShootPos((Entity)living, 1.0f));
                this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) - 1));
                this.f_19804_.m_135381_(MISSILE_FIRE_COOLDOWN, (Object)10);
                this.reloadCoolDown = 160;
            }
        }
    }

    public void travel() {
        this.trackEngine(true, 0.052, (Integer)VehicleConfigVVP.BRADLEY_ENERGY_COST.get(), 0.55, 0.5, 1.9, 0.8, 0.21f, -0.16f, 0.0026f, 0.002f, 0.1f);
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BMP_IDLE.get();
    }

    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.2f, -0.8f, 1.0f) : (i == 1 ? this.transformPosition(transformV, 0.0f, 1.2f, 0.0f) : (i == 2 ? this.transformPosition(transformV, 0.0f, 1.2f, 0.0f) : (i == 3 ? this.transformPosition(transformV, 0.0f, 1.2f, 0.0f) : (i == 4 ? this.transformPosition(transformV, 0.0f, 1.2f, 0.0f) : (i == 5 ? this.transformPosition(transformV, 0.0f, 1.2f, 0.0f) : (i == 6 ? this.transformPosition(transformV, 0.0f, 1.2f, 0.0f) : this.transformPosition(transformV, 0.0f, 1.0f, 0.0f)))))));
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public int getMaxPassengers() {
        return 7;
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.75f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.24138124f, 0.10408759f, 0.958325f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.00725625f, 2.7512188f, 0.2802875f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public float rotateYOffset() {
        return 2.7f;
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -this.turretMaxPitch() - r * this.m_146909_() - r2 * this.getRoll();
            float max = -this.turretMinPitch() - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState firePredicate(AnimationState<Bmp3Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 1 && this.getWeaponIndex(0) == 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire"));
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0 && this.getWeaponIndex(0) == 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return 330;
            }
            if (this.getWeaponIndex(0) == 1) {
                return 650;
            }
        }
        return 330;
    }

    public boolean canShoot(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFire;
            }
            if (this.getWeaponIndex(0) == 1) {
                return ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFireCoax;
            }
            if (this.getWeaponIndex(0) == 2) {
                return (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0 && (Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN) <= 0;
            }
        }
        return true;
    }

    public int getAmmoCount(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.f_19804_.m_135370_(MG_AMMO);
            }
            return (Integer)this.f_19804_.m_135370_(AMMO);
        }
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean banHand(LivingEntity entity) {
        return true;
    }

    public boolean hidePassenger(int index) {
        return true;
    }

    public int zoomFov() {
        return 3;
    }

    public int getWeaponHeat(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    public ResourceLocation getVehicleIcon() {
        return Mod.loc((String)"textures/vehicle_icon/bmp2_icon.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getWeaponIndex(0) == 0) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/bmp_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
            int heat = (Integer)this.m_20088_().m_135370_(HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 2\u041072 30MM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 1) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/lav_gun_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
            int heat = (Integer)this.m_20088_().m_135370_(COAX_HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 7.62MM PKTM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/lav_missile_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("  PTRK  " + String.valueOf(this.m_20088_().m_135370_(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("2\u041072 30MM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM PKTM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("PTRK " + String.valueOf(this.m_20088_().m_135370_(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), 30, -9, -1, false);
        }
    }

    public int getHudColor() {
        return 0xFFFFFF;
    }

    public boolean hasTracks() {
        return true;
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.22 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.27 : 0.36);
    }

    public boolean isEnclosed(int index) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return this.getSeatIndex(entity) != 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-Bmp3Entity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-Bmp3Entity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - 6.0 * player.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_() + 1.0), (double)(player.m_20188_() + 1.0)) - 6.0 * player.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - 6.0 * player.m_20252_((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return VVP.loc("textures/gui/vehicle/type/ru.png");
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb1, this.obb2, this.obb3, this.obb4, this.obb5, this.obb6, this.obbTurret);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition1 = this.transformPosition(transform, 0.0f, 2.0f, 1.0625f);
        this.obb1.center().set((Vector3fc)new Vector3f(worldPosition1.x, worldPosition1.y, worldPosition1.z));
        this.obb1.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 2.0f, -3.25f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 0.0f, 1.09375f, 0.65625f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, 1.71875f, 0.75f, -0.28125f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition5 = this.transformPosition(transform, -1.71875f, 0.75f, -0.28125f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition6 = this.transformPosition(transform, 0.0f, 1.09375f, -3.5625f);
        this.obb6.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obb6.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.0f, 0.0f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.SPRAY.get())) {
            if (!this.m_9236_().f_46443_) {
                int currentType = (Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE);
                int maxTypes = 5;
                int newType = (currentType + 1) % maxTypes;
                this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)newType);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.SPRAY.get(), this.m_5720_(), 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 1.0, 1.0, 1.0, 0.1);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)ModItems.SETKA_BODY.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_CACTUS_BODY)).booleanValue()) {
            return this.loadModule(player, stack, HAS_CACTUS_BODY, (Item)ModItems.SETKA_BODY.get());
        }
        if (stack.m_150930_((Item)ModItems.SETKA_TURRET.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_CACTUS_TURRET)).booleanValue()) {
            return this.loadModule(player, stack, HAS_CACTUS_TURRET, (Item)ModItems.SETKA_TURRET.get());
        }
        if (stack.m_150930_((Item)ModItems.MANGAL_BODY.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_MANGAL_BODY)).booleanValue()) {
            return this.loadModule(player, stack, HAS_MANGAL_BODY, (Item)ModItems.MANGAL_BODY.get());
        }
        if (stack.m_150930_((Item)ModItems.WRENCH.get())) {
            if (((Boolean)this.f_19804_.m_135370_(HAS_CACTUS_BODY)).booleanValue()) {
                return this.removeModule(player, HAS_CACTUS_BODY, (Item)ModItems.SETKA_BODY.get());
            }
            if (((Boolean)this.f_19804_.m_135370_(HAS_CACTUS_TURRET)).booleanValue()) {
                return this.removeModule(player, HAS_CACTUS_TURRET, (Item)ModItems.SETKA_TURRET.get());
            }
            if (((Boolean)this.f_19804_.m_135370_(HAS_MANGAL_BODY)).booleanValue()) {
                return this.removeModule(player, HAS_MANGAL_BODY, (Item)ModItems.MANGAL_BODY.get());
            }
        }
        return super.m_6096_(player, hand);
    }

    private InteractionResult loadModule(Player player, ItemStack stack, EntityDataAccessor<Boolean> flag, Item returnItem) {
        if (!this.m_9236_().f_46443_) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.f_19804_.m_135381_(flag, (Object)true);
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.REMONT.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult removeModule(Player player, EntityDataAccessor<Boolean> flag, Item returnItem) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(flag, (Object)false);
            ItemStack returnedItem = new ItemStack((ItemLike)returnItem, 1);
            boolean addedToInventory = player.m_150109_().m_36054_(returnedItem);
            if (!addedToInventory) {
                ItemEntity droppedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), returnedItem);
                this.m_9236_().m_7967_((Entity)droppedItem);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.REMONT.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public float getTurretMaxHealth() {
        return 125.0f;
    }

    public float getWheelMaxHealth() {
        return 60.0f;
    }

    public float getEngineMaxHealth() {
        return 135.0f;
    }

    public boolean hasPassengerTurretWeapon() {
        return false;
    }
}

